﻿<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="System.Linq" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="System.Collections.Generic" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport sprzeday wg kontrahentow</title>

    <script runat="server">
		
        public enum SortowanieWedług { WgKoduKontrahenta, WgNazwyKontrahenta }

        public class ParametryContext : ContextBase {
            BusinessModule businessmodule;

            public ParametryContext(Context cx)
                : base(cx) {
                businessmodule = BusinessModule.GetInstance(cx.Session);
            }

            SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyKontrahenta;

            [DefaultWidth(50)]
            [Priority(10)]
            public SortowanieWedług SortujWedług {
                get { return sortujWedług; }
                set {
                    sortujWedług = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            private bool _ignorujZaliczkowe = true;

            [Soneta.Tools.Priority(20)]
            public bool IgnorujZaliczkowe {
                get {
                    return this._ignorujZaliczkowe;
                }
                set {
                    this._ignorujZaliczkowe = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            FeatureDefinition cechaKontrahenta;

            [Priority(30)]
            [Caption("Cecha kontrahenta")]
            public FeatureDefinition CechaKontrahenta {
                get { return cechaKontrahenta; }
                set
                {
                    cechaKontrahenta = value;
                    OnChanged(EventArgs.Empty);
                    var f = GetListWartoscCechyKontrahenta() as List<DictionaryItem>;
                    if (f == null)
                    {
                        wartoscCechyKontrahenta = new DictionaryItem[] { };
                    }
                    else
                    {
                        wartoscCechyKontrahenta = new DictionaryItem[] { ((List<DictionaryItem>)GetListWartoscCechyKontrahenta()).FirstOrDefault() };
                    }
                }
            }

            public object GetListCechaKontrahenta() {
                // TID:13162; 
                RowCondition rc = new FieldCondition.Equal("TableName", "Kontrahenci");
                rc &= new FieldCondition.Equal("TypeNumber", FeatureTypeNumber.String);
                rc &= new FieldCondition.NotEqual("Dictionary", String.Empty);
                return businessmodule.FeatureDefs.ByName[rc];
            }           

            DictionaryItem[] wartoscCechyKontrahenta;

            [Priority(40)]
            [Caption("Wartość cechy kontr.")]
            public DictionaryItem[] WartoscCechyKontrahenta
            {
                get { return wartoscCechyKontrahenta; }
                set { wartoscCechyKontrahenta = value; OnChanged(EventArgs.Empty); }
            }

            public object GetListWartoscCechyKontrahenta()
            {
                var al = new List<DictionaryItem>();
                if (cechaKontrahenta == null)
                    return al;
                FeatureDefinition fd = businessmodule.FeatureDefs.ByName["Kontrahenci".TranslateIgnore(), cechaKontrahenta.Name];
                if (fd == null)
                    return al;
                // dla cech nie słownikowych DictionaryList = null;
                // chociaż teraz ich juz nie mozna wybrać w oknie parametrów; 
                if (fd.DictionaryList != null)
                {
                    foreach (DictionaryItem di in fd.DictionaryList)
                    {
                        al.Add(di);
                    }
                }
                var s = new string[] { "Caption".TranslateIgnore() };
                var lookupDef = new LookupInfo(new LookupInfo.EnumerableItem("Cechy", al, s));
                return lookupDef;
            }

            public bool IsReadOnlyWartoscCechyKontrahenta()
            {
                return cechaKontrahenta == null || (wartoscCechyKontrahenta.Count() == 1 && wartoscCechyKontrahenta[0] == null);
            }
        }

        static ParametryContext parametry;

        [Context]
        public static ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total {
            readonly Kontrahent kontrahent;
            decimal netto;
            decimal vat;
            decimal brutto;
            public Total(Kontrahent kontrahent) {
                this.kontrahent = kontrahent;
            }
            public void Add(DokumentHandlowy dokument) {
                netto += dokument.Suma.Netto;
                vat += dokument.Suma.VAT;
                brutto += dokument.Suma.Brutto;
            }
            public Kontrahent Kontrahent {
                get { return kontrahent; }
            }
            public decimal Netto {
                get { return netto; }
            }
            public decimal VAT {
                get { return vat; }
            }
            public decimal Brutto {
                get { return brutto; }
            }
            public string CechaKontrahenta {
                get {
                    if (Parametry.CechaKontrahenta == null)
                        return "nieokreślona";
                    return Kontrahent.Features[Parametry.CechaKontrahenta].ToString();
                }
            }
        }

        class NazwaComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Nazwa;
                string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Nazwa;
                if (Parametry.CechaKontrahenta != null) {
                    string c1 = t1.Kontrahent.Features[Parametry.CechaKontrahenta].ToString();
                    string c2 = t2.Kontrahent.Features[Parametry.CechaKontrahenta].ToString();
                    s1 = c1 + ":" + s1;
                    s2 = c2 + ":" + s2;
                }
                return s1.CompareTo(s2);
            }
        }

        class KodComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Kod;
                string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Kod;
                if (Parametry.CechaKontrahenta != null) {
                    string c1 = t1.Kontrahent.Features[Parametry.CechaKontrahenta].ToString();
                    string c2 = t2.Kontrahent.Features[Parametry.CechaKontrahenta].ToString();
                    s1 = c1 + ":" + s1;
                    s2 = c2 + ":" + s2;
                }
                return s1.CompareTo(s2);
            }
        }

        void OnContextLoad(Object sender, EventArgs args) {
            Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
            if (pars.Kategoria == KategoriaHandlowa.Sprzedaż) {
                string t = string.Format("Raport sprzedaży wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.Zakup) {
                string t = string.Format("Raport zakupów wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.WydanieMagazynowe) {
                string t = string.Format("Raport wydań wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.PrzyjęcieMagazynowe) {
                string t = string.Format("Raport przyjęć wg kontrahentów|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            if (pars.Kontrahent != null)
                ReportHeader.Title += string.Format("|</STRONG>Kontrahent<STRONG>: {0}", pars.Kontrahent.ToString());
            if (pars.Definicja != null)
                ReportHeader.Title += string.Format("|</STRONG>Definicja:<STRONG> {0}", pars.Definicja.ToString());
            if (pars.Okres != Soneta.Types.FromTo.All)
                ReportHeader.Title += string.Format("|</STRONG>Okres:<STRONG> {0}", pars.Okres.ToString());
            if (Parametry.CechaKontrahenta != null)
                ReportHeader.Title += "|Cecha: </STRONG>" + Parametry.CechaKontrahenta.Name + "<STRONG>";
                                  
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();

            if (Parametry.CechaKontrahenta != null && Parametry.WartoscCechyKontrahenta != null)
            {
                var wartosci = new List<string>();
                foreach (var w in Parametry.WartoscCechyKontrahenta)
                    wartosci.Add(w.Value.ToString());

                string[] wartosciTable = wartosci.ToArray();

                 foreach (DokumentHandlowy dokument in rows) {
                    if (dokument.Anulowany) continue;
                    if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                    if (dokument.Definicja.DuplikatWartosci) continue;
                    if (dokument.Kontrahent == null) continue;

                    bool jestZgodnaWartosc = false;
                    foreach (string wart in wartosciTable)
                    {
                        if (!string.IsNullOrEmpty(wart.Trim()) && wart.Trim() == dokument.Kontrahent.Features[Parametry.CechaKontrahenta] as string)
                        {
                            jestZgodnaWartosc = true;
                            break;
                        }
                    }

                    if (!jestZgodnaWartosc)
                    {
                        continue;
                    }                
				
                    Total t = (Total)result[dokument.Kontrahent];
                    if (t == null) {
                        t = new Total(dokument.Kontrahent);
                        result.Add(t.Kontrahent, t);
                    }
                    t.Add(dokument);
                }
            }         

            ArrayList lista = new ArrayList(result.Values);
            if (Parametry.CechaKontrahenta != null && Parametry.WartoscCechyKontrahenta != null)
                switch (Parametry.SortujWedług) {
                    case SortowanieWedług.WgKoduKontrahenta:
                        lista.Sort(new KodComparer());
                        break;
                    case SortowanieWedług.WgNazwyKontrahenta:
                        lista.Sort(new NazwaComparer());
                        break;
                }
            Grid.DataSource = lista;
        }
        
    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Raport sprzedaży wg kontrahentów" runat="server">
        </eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            GroupLine="Wartość cechy kontrahenta: {0}" GroupData0="CechaKontrahenta" DataMember="Total"
            ShowGroupSum="true">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"
                    EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn Width="18" Align="Left" DataMember="Kontrahent.Kod" Caption="Kod"
                    NoWrap="True" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="48" DataMember="Kontrahent.Nazwa" Caption="Kontrahent" NoWrap="True"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Align="Right" DataMember="VAT" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Align="Right" DataMember="Brutto" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

